<?php
/**
 * Post-entry title.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.16.0
 */

if ( is_single() ) :
	if ( get_theme_mod( 'blog_single_header_category', 1 ) ) :
		echo '<h6 class="entry-category is-xsmall">';
		echo '<i class="fa-solid fa-tags" style="margin-right:3px"></i>';
		echo get_the_category_list( __( ', ', 'flatsome' ) );
		echo '</h6>';
	endif;
else :
	echo '<i class="fa-solid fa-tags"></i>';
	echo '<h6 class="entry-category is-xsmall">';
	echo get_the_category_list( __( ', ', 'flatsome' ) );
	echo '</h6>';
endif;

if ( is_single() ) :
	if ( get_theme_mod( 'blog_single_header_title', 1 ) ) :
		echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
		echo '<div class="entry-divider is-divider small"></div>';
	endif;
else :
	echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
endif;
?>
<div class="entry-content-before single-page">
	<div class="thong-tin-meta">
	<span class="luot-xem"><i class="fa-solid fa-eye"></i>
		<?php echo getPostViews(get_the_ID()); ?>
	</span>
	<span class="ngay-dang-bai"><i class="fa-solid fa-calendar-days"></i>
		<?php echo get_the_date();?>
	</span>
</div>
	<div class="blog-share-icon text-center">
		<?php if (get_theme_mod('blog_share', 1)) {
            // SHARE ICONS
            echo do_shortcode('[share]');
        } ?>
	</div>
		
</div>
<style>.entry-content-before.single-page {
    display: block;
}.thong-tin-meta {
    display: inline;
    font-size: 14px;
    color: #979797;
    float: left;
}.blog-share-icon.text-center {
    display: inline;
    float: right;
}</style>