<?php

/**
 * Posts content single.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.16.0
 */

?>
<div class="show-excerp-news">
    <?php the_excerpt() ?>
</div>
<div class="row row-collapse">
    <div class="col medium-12 small-12 large-12">
        <div class="entry-content single-page">

            <?php the_content(); ?>
            <?php
            wp_link_pages(array(
                'before' => '<div class="page-links">' . __('Pages:', 'flatsome'),
                'after'  => '</div>',
            ));
            ?>
        </div>
    </div>
</div>
<h3 class="title-news">Bài viết mới cập nhật:</h3>
<div class="newpost">
    <ul>
        <?php
        $postquery = new WP_Query(array('posts_per_page' => 8, 'orderby' => 'rand'));
        if ($postquery->have_posts()) {
            while ($postquery->have_posts()) : $postquery->the_post();
                $do_not_duplicate = $post->ID;
        ?>

                <li>
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </li>

        <?php endwhile;
        }
        wp_reset_postdata(); ?>
    </ul>

</div>
<div class="col medium-12 small-12 large-12">
    <?php if (get_theme_mod('blog_share', 1)) {
        // SHARE ICONS
        echo '<div class="blog-share text-center">';
        echo '<div class="is-divider medium" style="max-width:100%;height:1px;background-color:rgb(0 182 189);"></div>';
        echo '<span class="label" style="margin-right:5px">Chia sẻ bài viết:</span>';
        echo do_shortcode('[share]');
        echo '</div>';
    } ?>
</div>


<?php if (function_exists('rank_math_the_breadcrumbs')) rank_math_the_breadcrumbs(); ?>
<?php if (get_theme_mod('blog_single_footer_meta', 1)) : ?>
    <footer class="entry-meta text-<?php echo get_theme_mod('blog_posts_title_align', 'center'); ?>">
        <?php
        /* translators: used between list items, there is a space after the comma */
        $category_list = get_the_category_list(__(' ', 'flatsome'));

        /* translators: used between list items, there is a space after the comma */
        $tag_list = get_the_tag_list('', __(' ', 'flatsome'));


        // But this blog has loads of categories so we should probably display them here.
        if ('' != $tag_list) {
            $meta_text = __('<div class="danh-muc"><span class="tag-danh-muc">Danh mục:</span> %1$s</div><div class="the-tim-kiem"><span class="tag-tu-khoa">Từ khóa:</span> %2$s</div>', 'flatsome');
        } else {
            $meta_text = __('<div class="danh-muc"><span class="tag-danh-muc">Danh mục:</span>  %1$s</div>', 'flatsome');
        }

        printf($meta_text, $category_list, $tag_list, get_permalink(), the_title_attribute('echo=0'));
        ?>
    </footer><!-- .entry-meta -->
<?php endif; ?>
<?php if (get_theme_mod('blog_single_next_prev_nav', 1)) :
    flatsome_content_nav('nav-below');
endif; ?>
<?php if (get_theme_mod('blog_author_box', 1)) : ?>
    <div class="entry-author author-box">
        <div class="flex-row align-top">
            <div class="flex-col mr circle">
                <div class="blog-author-image">
                    <?php
                    $user = get_the_author_meta('ID');
                    echo get_avatar($user, 90);
                    ?>
                </div>
            </div><!-- .flex-col -->
            <div class="flex-col flex-grow">
                <h5 class="author-name uppercase pt-half">
                    <?php echo esc_html(get_the_author_meta('display_name')); ?>
                </h5>
                <p class="author-desc small"><?php echo esc_html(get_the_author_meta('user_description')); ?></p>
            </div><!-- .flex-col -->
        </div>
    </div>
<?php endif; ?>
<?php
/*
 * Code hiển thị bài viết liên quan trong cùng 1 category
 */
$categories = get_the_category(get_the_ID());
if ($categories) {
    echo '<div class="bai-viet-lien-quan">';
    $category_ids = array();
    foreach ($categories as $individual_category) $category_ids[] = $individual_category->term_id;
    $args = array(
        'category__in' => $category_ids,
        'post__not_in' => array(get_the_ID()),
        'posts_per_page' => 6, // So bai viet dc hien thi
    );
    $my_query = new wp_query($args);
    if ($my_query->have_posts()) :
        echo '<div class="relatedcat">';
        echo '<h4><span style="color: #00adb3;">Bài Viết Cùng Chủ Đề:</span></h4>
        <div class="row related-post">';
        while ($my_query->have_posts()) : $my_query->the_post();
?>
            <div class="col large-4 medium-4 small-12">
                <div class="feature">
                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_post_thumbnail('medium'); ?></a>
                </div>
                <div class="related-title">
                    <a href="<?php the_permalink() ?>">
                        <?php the_title(); ?>
                    </a>
                </div>
            </div>

<?php
        endwhile;
        echo '</div>';
        echo '</div>';
    endif;
    wp_reset_query();
    echo '</div>';
}
?>

<style>

    .related-title {
        line-height: 1.3 !important;
        margin-top: 10px !important;
        text-overflow: ellipsis;
        overflow: hidden;
        display: -webkit-box;
        -webkit-box-orient: vertical;
        -webkit-line-clamp: 2;
    }

    .entry-meta.text-left .tag-danh-muc,.entry-meta.text-left .tag-tu-khoa {
        border-radius: 4px;
        background: #00969b;
        padding: 4px 10px;
        color: #fff;
        margin-right: 5px;
    }

    .show-excerp-news {
        display: inline-block;
		width:100%;
        background: #f9f9f9;
        border-left: 10px solid #00b6bd;
        padding-left: 10px;
        padding-top: 12px;
        padding-bottom: 0.9px;
        margin-bottom: 12px;
        font-style: italic;
    }

    .show-excerp-news p:before {
        color: #00b6bd;
        content: open-quote;
        font-size: 4em;
        line-height: .1em;
        margin-right: .25em;
        vertical-align: -.4em;
    }
.newpost {
    background: #80bb35;
    padding: 10px;
    border: 1px dashed #00b38f;
    border-radius: 3px;
}
.newpost ul {
    margin-bottom: 0;
}
.newpost ul li {
    color: #fff;
    margin-left: 20px;
}
.newpost ul li a {
    color: #fff;
}
.article-inner ul li {
    margin-bottom: 2px;
}
    footer.entry-meta.text-left a {
        padding: 2px 9px;
        background-color: #ececec;
        margin-right: 10px;
    }

    footer.entry-meta.text-left a:before {
        font-family: 'FontAwesome';
        font-size: 18px;
        content: '\f02b';
        margin-right: 8px;
        color: #f8a32c !important;
    }

    footer.entry-meta.text-left a:hover {
        background-color: rgba(27, 127, 204, .8);
        color: #fff;
    }
    }
</style>